<script>
    $(document).ready(function () {
        // Click event for the button
        $('.addDevicePaymentModal').on('click', function () {
            // Retrieve data from clicked row
            let accountNo = $(this).data('deviceaccountno');
            let accountName = $(this).data('devicename');
            let accountBalance = $(this).data('devicebalance');

            // Set modal input fields
            $('#id_u_device').val(accountNo);
            $('#txt_acct_holder_device').val(accountName);
            $('#meterbalance_device').val(accountBalance); // Assuming id-5 is used for displaying balance
        });
    });
</script>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Add Payment Modal -->
<div id="addDevicePaymentModal" class="modal fade">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Add Meter Device Payment</h4>
        <form id="user_form_meterdevicepayment" method="POST">
    
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
      </div>
      <div class="modal-body">
    
      <div class="row">
          <div class="col-sm-3">
            <label for="id_u_device">Account#: </label>
            <input type="text" id="id_u_device" name="id" class="form-control" readonly>
          </div>
          <div class="col-sm-9">
            <label for="txt_acct_holder_device">Account Holder: </label>
            <input type="text" id="txt_acct_holder_device" name="acctholder_device" class="form-control" readonly>
          </div>
        </div>
        <br>
        <div class="card card-primary card-outline card-tabs">
          <div class="card-header p-0 pt-1 border-bottom-0">
            <ul class="nav nav-tabs">
              <li class="nav-item">
                <a class="nav-link active" data-toggle="pill" href="#custom-tabs-three-waterbill" role="tab">Meter Device</a>
              </li>
            </ul>
          </div>
          <div class="card-body">
            <div class="tab-content">
              <!-- Meter Device Tab -->
              <div class="tab-pane fade show active" id="custom-tabs-three-waterbill" role="tabpanel">
                <center><b style="color: #e90707;">PAY METER DEVICE</b></center>
               
                  <div class="form-group" style="background:rgb(14, 34, 95); padding: 10px; color: #fff;">
                    <label>Unpaid Balance:</label>
                    <input type="text" id="meterbalance_device" name="meterbalance_device" class="form-control" style="font-size: 18px; color: red; font-weight: bold;" readonly>
                  </div>
                  <div class="form-group">
                    <label for="payment_ref_meter">Payment Reference Number:</label>
                    <input type="text" id="payment_ref_meter" name="payment_ref_meter" class="form-control" readonly>
                  </div>
                  <div class="form-group">
                    <label for="meter_payment_date">Payment Date:</label>
                    <input readonly type="date" value="<?php echo isset($thedatetoday) ? $thedatetoday : date('Y-m-d'); ?>" class="form-control" id="meter_payment_date" name="payment_date" <?php if ($_SESSION['username'] != 'MainAdmin') echo 'readonly'; ?>>
                  </div>
                  <div class="form-group">
                    <label>Enter Amount:</label>
                    <input type="text" name="meterdevice_amount" min="0" placeholder="0" class="form-control" style="font-size: 40px; color: #ff0505; padding: 10px; font-weight: bold; text-align: center;" required>
                  </div>
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="modeofpay" id="inlineRadio1_meter" value="CASH" checked>
                    <label class="form-check-label"><b>CASH</b></label>
                  </div>
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="modeofpay" id="inlineRadio2_meter" value="GCASH">
                    <label class="form-check-label"><b>G-CASH</b></label>
                  </div>
                  <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-radius btn-block btn-multi text-white" id="btn-meterpayment">Submit Payment</button>
                  </div>
 </form>
              </div>
            </div>
          </div>
        </div>
      </div>     
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>

      // Generate unique payment reference number
    function generateDeviceReference() {
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        let refNumberDevicePayment = '';
        for (let i = 0; i < 10; i++) {
          refNumberDevicePayment += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return refNumberDevicePayment;
    }

    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('payment_ref_meter').value = generateDeviceReference();
    });
 

    $(document).ready(function () {
        // Click event to populate modal fields
        $('.addDevicePaymentModal').on('click', function () {
            $('#id_u_device').val($(this).data('deviceaccountno'));
            $('#txt_acct_holder_device').val($(this).data('devicename'));
            $('#meterbalance_device').val($(this).data('devicebalance'));
        });

        // Handle form submission with AJAX
        $('#user_form_meterdevicepayment').on('submit', function (e) {
            e.preventDefault();

            $.ajax({
                url: 'submit_meterpayment.php',
                type: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                beforeSend: function() {
                    Swal.fire({
                        title: 'Processing...',
                        text: 'Please wait...',
                        allowOutsideClick: false,
                        didOpen: () => Swal.showLoading()
                    });
                },
                success: function (response) {
                    $('#addDevicePaymentModal').modal('hide'); // Hide modal

                    Swal.fire({
                        title: response.statusCode === 200 ? 'Success!' : 'Error!',
                        text: response.message,
                        icon: response.statusCode === 200 ? 'success' : 'error',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        if (response.statusCode === 200) {
                            window.location.href = 'printlogs.php';
                        }
                    });
                }
            });
        });
    });
</script>

 