<?php
 session_start();
 require_once('../connect.php');
 require_once('sql_required.php');

 $datetoday = date('Y-m-d'); 
$active_tab = "members";  ?>  
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Members</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
  <link rel="icon" href="images/logo.png" type="image/png" sizes="16x16">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" type="text/css" href="css/style1.css">
  <link rel="stylesheet" type="text/css" href="css/skeleton_loading.css">
<style type="text/css">
  .content-wrapper {
    background: #151e27!important;
  }
  @media(max-width:800px) {
    .modal-content {
      position: fixed; bottom: 40%; width: 96%; left: 7;
    }
    .modal-dialog {
      margin: 0!important; padding: 0!important;
    }
  }
  .page-item.active .page-link {
    background-color: #27313d!important;
    border-color: #27313d!important;
    color: #000;
  }
  .page-item .page-link {
    background-color: #151e27!important;
    border-color: grey!important;
    color: grey!important;
  }
  .txn-history {
    text-align: left;
  }
  .txn-list {
    background-color: #1d2532;
    padding: 12px 10px; 
    color: #777;
    font-size: 14px;
    margin: 7px 0;
    box-shadow: 0 2px 5px 0 rgba(0,0,0,.16), 0 2px 10px 0 rgba(0,0,0,.12)!important;
    cursor: pointer;
  }
  .transaction-amount {
    float: right;
    color: #fff;
    font-weight: 800;
  }
  .transaction-number {
   float: right;
  }
  .form-control {
    border-radius: 10px;
  }
  .form-control:focus {
    border: 1px solid #ffd700!important;
  }
  @media(max-width:991px) {
    #order_full_screen {
      display: none!important;
    }
    #order_small_screen {
      display: block!important;
    }
  }
</style>
</head>
<body class="hold-transition sidebar-mini layout-footer-fixed layout-fixed" style="background: #151e27;">
<div id="preloader" class="loading" style="display: none"></div>
<div class="wrapper">
  <nav class="main-header navbar navbar-expand navbar-white" style="background: #151e27; border-bottom: 0; box-shadow: none!important;">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a href="index.php?<?php echo generate_string($permitted_chars, 100); ?>" class="withanimation back_arrow"><i class="fas fa-angle-left pr-2" style="font-size: 20px; color: #ffd700;"></i></a><span class="brand-text" style="font-size: 20px;"><span style="font-size: 20px; font-weight: bolder; line-height: 20px; color: #fff;">Members List | [ <a href="add_new.php"> Add New </a>]</span></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
    </ul>
  </nav>

<?php include ("navbar.php")?>
<div class="content-wrapper">
  <section class="content">
    <div class="container-fluid">
            <div class="card mt-3" style="border-radius: 10px; background-color: #1d2532; color: #fff;">
              <div class="card-body table-responsive p-3">
                  <table id="members_table" class="table table-striped">
                    <thead>
                    <tr> 
                      <th width="5%">Account Number</th>
                      <th>Contact Person/s</th>
                      <th>Account Holder</th>
                      <th>Mobile Number</th>
                      <th>Home Address</th>
                      <th>Connection Status</th>
                      <th>Date Registered</th>
                      
                      <th width="17%">Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php 
                      $sql_members = "SELECT * FROM tbl_user_account";
                      $result_members = $conn->query($sql_members);
                        while($row_members = mysqli_fetch_array($result_members)) {
                    ?>
                    <tr>
                      <td style="color: #ffd700;"><?php echo $row_members['unique_id']  ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['username']; ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['firstname'].$row_members['mi'].$row_members['lastname']; ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['mobilenumber']; ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['home_address']; ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['line_status']; ?></td>
                      <td style="color: #ffd700;"><?php echo $row_members['date_registered']; ?></td>
                   
                
                      <td>
                        <a data-toggle="modal" data-target="#members<?php echo $row_members['unique_id']; ?>" class="btn btn-sm btn-info">View Details</a>
                     </td>
                    </tr>

          




                    <div class="modal" id="members<?php echo $row_members['unique_id']; ?>">
                      <div class="modal-dialog">
                        <div class="modal-content" style="background-color: #151e27!important;">
                          <div class="modal-header pb-0" style="border: 0px;">
                            <h5 class="modal-title text-white" style="font-weight: bold;">Member Summary Details</h5>
                          </div>
                          <div class="modal-body pt-2 pb-0">
                            <div class="txn-history">
                              <p class="txn-list">


                              
                              <?php 
                              $sql_user_details = "SELECT * FROM tbl_members_report WHERE Branch = 'Laguna' and account_no = '".$row_members['unique_id']."' order by reading_date desc limit 1";
                              $result_user_details = mysqli_query($conn, $sql_user_details);
                              $row_user_details = mysqli_fetch_assoc($result_user_details);
                              $account_name = $row_user_details['account_name'];
                              $reading_date = $row_user_details['reading_date'];
                              $total_reading = $row_user_details['prev_reading'];
                              $balance = $row_user_details['balance'];
                              $due_date = $row_user_details['due_date'];
                               
                               
                               ?>


                       
                                <span class="text-white">Account No: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_members['unique_id']; ?></span><br>
                               
                                <span class="text-white">Name: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_user_details['account_name']; ?></span><br>
                                 <span class="text-white">Last Reading Date: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_user_details['reading_date']; ?></span><br>
                                <span class="text-white">Previous Reading: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_user_details['prev_reading']; ?></span><br>
                                <span class="text-white">Unpaid Bill: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_user_details['balance']; ?></span><br>
                                <span class="text-white">Due Date: </span><span class="transaction-amount" style="color: #ffd700;"><?php echo $row_user_details['due_date']; ?></span><br>
                              
                             
                              </p>

                            </div>
 
                          </div>
 


                          <div class="modal-footer" style="border: 0px">
                          [ <a href="add_new_reading.php?id=<?php echo $row_members['unique_id'] ?> "> Add New Reading </a>] [ <a href="edit_profile.php?id=<?php echo $row_members['unique_id'] ?> "> Edit Account </a>]
                            <button type="button" class="btn btn-default btn-lg btn-block" style="background: transparent; color: #fff;" data-dismiss="modal">Close</button>
                          </div>
                        </div>
                      </div>
                    </div>

                    <?php } ?>
                    </tbody>
                  </table>
                </div>
            </div>

    </div>
  </section>
</div>
</div>

<script src="dist/js/adminlte.min.js"></script>
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="plugins/jquery-validation/additional-methods.min.js"></script>
<script src="dist/js/pages/dashboard.js"></script>
<script src="plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript">
$(document).ready(function () {
  $('#search').keyup(function() {
    var members = $(this).val();
    var btn_action = "member_search";
     $.ajax({
      url:'fetch_data.php',
      method:"POST",
      dataType:"html",
      data:{members:members, btn_action:btn_action},
      success:function(data){
        $('#members_result').html(data);
      }
    });
  });
});
$(function () {
  $("#members_table").DataTable({
    "responsive": true,
    "autoWidth": false,
  });
  $('#example2').DataTable({
    "paging": true,
    "lengthChange": false,
    "searching": false,
    "ordering": true,
    "info": true,
    "autoWidth": false,
    "responsive": true,
  });
  $(".withanimation").click(function(e) {
      e.preventDefault();
      $(".loading").show();
      var url=$(this).attr("href");
      setTimeout(function() {
          window.location=url;
      }, 500);
  });
});
</script>
</body>
</html>
