<?php
$page = basename($_SERVER['PHP_SELF'], ".php");
?>

<div class="modal fade" id="pinModal" tabindex="-1" role="dialog" aria-labelledby="pinModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <br>
            <center>
                <h5 class="modal-title" id="pinModalLabel"><b>Enter PIN  <i class="fas fa-user-lock"></i> </b></h5>
            </center>

            <div class="modal-body text-center">
                <!-- PIN display -->
               <div class="position-relative text-center mb-3">
                <div id="pin-display" style="font-size: 28px; font-weight: bold; letter-spacing: 10px;">••••••</div>
                    <span id="toggle-visibility" style="position: absolute; right: 10px; top: 0; cursor: pointer;">
                        <i class="fas fa-eye-slash"></i>
                    </span>
                </div>



                <div class="d-flex flex-wrap justify-content-center" style="max-width: 400px; margin: 0 auto;">
                    <div class="w-100 text-center">
                        <?php for ($i = 1; $i <= 9; $i++) { ?>
                            <button class="btn btn-secondary m-1 pin-button square-btn"><?= $i ?></button>
                            <?php if ($i % 3 === 0) { ?><br><?php } ?>
                        <?php } ?>
                        <button class="btn btn-secondary m-1 pin-button square-btn">0</button>
                        <button class="btn btn-danger m-1 square-btn" id="clear-pin">Clear</button>
                        <button class="btn btn-primary m-1 square-btn" id="submit-pin">OK</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<footer class="main-footer footer-nav bg-dark text-white shadow">
  <div class="footer-menu d-flex justify-content-around align-items-center text-center">
    
    <a href="index.php" class="footer-item <?php if($page == 'index') echo 'active-footer'; ?>">
      <i class="fa fa-tachometer-alt"></i>
      <p>Dashboard</p>
    </a>

    <a href="printlogs.php" class="footer-item <?php if($page == 'printlogs') echo 'active-footer'; ?>">
      <i class="fas fa-money-bill-alt"></i>
      <p>Payments</p>
    </a>

    <?php if ($_SESSION['username'] == 'superadmin') { ?>
      <a href="sortreadings.php" class="footer-item <?php if($page == 'sortreadings') echo 'active-footer'; ?>">
        <i class="fas fa-wallet"></i>
        <p>Reading</p>
      </a>
    <?php } else { ?>
      <a href="printlogs_reading.php" class="footer-item <?php if($page == 'printlogs_reading') echo 'active-footer'; ?>">
        <i class="fas fa-wallet"></i>
        <p>Reading</p>
      </a>
    <?php } ?>

    <?php if ($_SESSION['username'] == 'MainAdmin') { ?>
      <a href="#" data-toggle="modal" data-target="#pinModal" class="footer-item <?php if($page == 'more') echo 'active-footer'; ?>">
        <i class="fa fa-user"></i>
        <p>More</p>
      </a>
    <?php } else { ?>
      <a href="indexcollection.php" class="footer-item <?php if($page == 'indexcollection') echo 'active-footer'; ?>">
        <i class="fas fa-pen"></i>
        <p>Reports</p>
      </a>
    <?php } ?>

  </div>
</footer>

<style>
.footer-nav {
  position: fixed;
  bottom: 0;
  width: 100%;
  z-index: 999;
  padding: 10px 0;
  background-color: #67105e;
  box-shadow: 0 -2px 6px rgba(0,0,0,0.2);
}
.bg-dark {
      background-color: #67105e !important;
}

.footer-menu {
  flex-wrap: nowrap;
  padding: 0 10px;
}

.footer-item {
  flex: 1;
  text-decoration: none;
  color: #bfbfbf;
  font-size: 13px;
  padding: 5px 0;
  transition: all 0.3s ease-in-out;
}

.footer-item i {
  display: block;
  font-size: 18px;
}

.footer-item p {
  margin: 3px 0 0;
  font-size: 12px;
}

.footer-item:hover,
.footer-item.active-footer {
  color: #ffffff;
  font-weight: 500;
}

@media (min-width: 768px) {
  .footer-item i {
    font-size: 20px;
  }

  .footer-item p {
    font-size: 13px;
  }
}
</style>

<script>
    const defaultPin = "626262";
    let enteredPin = "";
    let isVisible = false;

    // Toggle pin visibility
    document.getElementById("toggle-visibility").addEventListener("click", () => {
        isVisible = !isVisible;
        updatePinDisplay();
        const icon = document.querySelector("#toggle-visibility i");
        icon.classList.toggle("fa-eye", isVisible);
        icon.classList.toggle("fa-eye-slash", !isVisible);
    });

    // Handle numeric button clicks
    document.querySelectorAll(".pin-button").forEach(button => {
        button.addEventListener("click", () => {
            if (enteredPin.length < 6) {
                enteredPin += button.textContent;
                updatePinDisplay();
            }
        });
    });

    // Clear button functionality
    document.getElementById("clear-pin").addEventListener("click", () => {
        enteredPin = "";
        updatePinDisplay();
    });

    // OK button functionality
    document.getElementById("submit-pin").addEventListener("click", () => {
        if (enteredPin === defaultPin) {
            setTimeout(() => {
                window.location.href = "more.php";
            }, 100);
        } else {
            alert("Incorrect PIN. Please try again.");
            enteredPin = "";
            updatePinDisplay();
        }
    });

    // Update the PIN display
    function updatePinDisplay() {
        const display = document.getElementById("pin-display");
        if (isVisible) {
            display.textContent = enteredPin.padEnd(6, "_");
        } else {
            display.textContent = "•".repeat(enteredPin.length).padEnd(6, "_");
        }
    }
</script>

